#!/usr/bin/env python
# -*- coding: UTF-8 -*-

#
#american dent Screenlet
#Copyright (C) 2010 El Khalifa Karim
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#

# Import a few necessary components for the script to run
import screenlets
from screenlets.options import StringOption, BoolOption, IntOption
import cairo
import pango
import gtk
import gobject
import locale
import pango
import time
import os.path


# Begin Creating the actual program by creating the class...MUST ACCEPT screenlets.Screenlet.
class americanDebtScreenlet(screenlets.Screenlet):
	"""Give an estimation of the United states of america's public debt"""

	# Default Meta Info for Screenlet
	__name__ = 'American Debt Screenlet'
	__version__ = '0.1'
	__author__ = 'Karim El Khalifa kabushi@moutons.ch'
	__desc__ = __doc__

	# Internal Variables
	__timeout = None
	p_layout = None

	__base_debt = 11719258192538.99
	__update_interval = 1000
	

# Define the initialization function - Some variation on this __init__ function is necessary for all screenlets.
	def __init__(self, **keyword_args):
		""" Initialisation du screenlet """
		# Call screenlets.Screenlet.__init__ => Required!
		# Declare the basic attributes of the screenlet - width, height
		screenlets.Screenlet.__init__(self, width=320, height=100, **keyword_args)
		# Tells the screenlet which theme to use
		self.theme_name="default"
		# Create the "basic" pop-up menu that should be displayed when right-clicked
		# Add an extra tab under the "options" tab on the "properties" dialog
#		self.add_options_group('System', 'Text Display Options')

	def on_init(self):
		self.add_default_menuitems()
		if self.__timeout:
			gobject.source_remove(self.__timeout)
		self.__timeout = gobject.timeout_add(self.__update_interval, self.update)

	# Define the __setattr__ function - This is also called when the script is executed
	def __setattr__(self, name, value):
		# Call screenlets.Screenlet.__setattr__ => Required!
		screenlets.Screenlet.__setattr__(self, name, value)

	# Define the update function - in this case, what to do when the timer expires
	def update(self):

		self.redraw_canvas()
		if self.__timeout:
			gobject.source_remove(self.__timeout)
		self.__timeout = gobject.timeout_add(self.__update_interval, self.update)
		return True

	# The 'on_draw' function tells the script how to draw the widget
	def on_draw(self, ctx):
		# Make sure the scale value is within the acceptable range
		if self.scale > 5:
			self.scale = 5
		# If the theme is set (in our case, it is set as "default"), draw the screenlet
		if self.theme:
			# Draw background.png onto the screen (in the folder ./themes/default/)
			ctx.save()
			ctx.scale(self.scale, self.scale)
			ctx.translate(0, 0)
			ctx.set_source_surface(cairo.ImageSurface.create_from_png(os.path.abspath(os.path.dirname(__file__))+"/themes/default/planche.png"), 0, 0)
			ctx.paint()
			#self.theme.render(ctx, 'background')
			ctx.restore()

			# Draw the text onto the background
			# Depends on the 'draw_text()' function defined below
			ctx.save()
			ctx.scale(self.scale, self.scale)

			debt = self.getDebt()
			self.draw_text(ctx, self.presentationDuNombre(debt), 0, 30, self.width, "Sans", 20,0,0,0,1)
			ctx.restore()
			

	# This on_draw_shape provides for the majority of the functionality of the program
	# Without this function, you would be unable to "right click" on the widget (the menu
	# for the window behind it would appear) and you would be unable to move the screenlet
	# once it appears on the screen.
	def on_draw_shape(self, ctx):
		if self.theme:
			self.on_draw(ctx)

	# This is a user defined function that will tell python how to draw the text onto the background
	def draw_text(self, ctx, value, x, y, width, font, size,r=1,g=1,b=1,o=0.8,sens=1):
		""" ecrit un texte dans le contexte cairo ctx"""
		ctx.save()
		ctx.translate(x, y)
		# Create a layout for the text which will be drawn on the background later
		if self.p_layout == None:
			self.p_layout = ctx.create_layout()
		else:
			ctx.update_layout(self.p_layout)
		# The next four lines set up the font for the layout
		p_fdesc = pango.FontDescription()
		p_fdesc.set_family(font)
		p_fdesc.set_size(size * pango.SCALE)
		self.p_layout.set_font_description(p_fdesc)
		# Define how wide the text can be that is written to the screen, in pixels
		self.p_layout.set_width(width * pango.SCALE)
		# Left-Align the text
		if sens== 1:
			self.p_layout.set_alignment(pango.ALIGN_LEFT)
		else:
			self.p_layout.set_alignment(pango.ALIGN_RIGHT)
		self.p_layout.set_markup(value)
		# Set the color of the text
		# Setup: (RED, GREEN, BLUE, OPACITY) => All values go from 0 to 1 (float format)
		ctx.set_source_rgba(r, g, b, o)
		# Display the text
		ctx.show_layout(self.p_layout)
		# Center the text on the background
		self.p_layout.set_alignment(pango.ALIGN_CENTER)
		ctx.restore()


	def getTimeFrom2009082411(self):
		""" retourne le nombre de seconde à GMT -0400 depuis le 24 aout 2009 11 GMT -0400 """
		timeTuple=(2009,8,24, 11, 0, 0, 0, 0, 0) 
		
		return int((time.time() - self.getDiffGMT()*60*60) - time.mktime(timeTuple))
	
	def getDiffGMT(self):
		""" return the gmt time difference between UTC and Washingthon DC """
		return 4
	
	def getDebt(self):
		""" Retourne la valeur de la dette sous forme d'entier long """
		taux_par_seconde = 50735
		return long(self.__base_debt + (taux_par_seconde* self.getTimeFrom2009082411()))

	def presentationDuNombre(self,num):
		""" met en forme le montant de la dette """
		strin = str(num)
		strout = ""
		mod = len(strin) % 3
		i = 1
		while i < len(strin):
			strout = strout + strin[i-1:i]
			if i % 3 == mod:
				strout = strout + ","
			i = i+1
		strout = '$ ' + strout + strin[i-1:i]
		
		return strout
		
		
# If the program is run directly or passed as an argument to the python
# interpreter then create a Screenlet instance and show it
# Essentially, initialize the program
if __name__ == "__main__":
	import screenlets.session
	screenlets.session.create_session(americanDebtScreenlet)
	
