#!/usr/bin/env python

# EarthquakeScreenlet  (c) 2008-2010 El Khalifa Karim karim.elkhalifa @ moutons.ch
#


import screenlets
from screenlets import DefaultMenuItem
from screenlets.options import BoolOption, IntOption
import cairo
import gtk
import wnck
import gobject
import commands
import sys
import os


try:
	import webkit
except:
	dialog = gtk.MessageDialog(buttons=gtk.BUTTONS_CLOSE)
	dialog.set_markup('You dont have webkit , please install python webkit')
	dialog.run()
	dialog.destroy()
	print('You dont have webkit , please install python webkit')
	sys.exit()

class EarthquakeScreenlet (screenlets.Screenlet):
	"""This screenlets show you the last earthquakes in the world.	"""
	
	# default meta-info for Screenlets
	__name__		= 'EarthquakeScreenlet'
	__version__		= '0.2'
	__author__		= 'El Khalifa Karim'
	__desc__		= __doc__
	
	width = 562
	height = 306
	box = None
	moz = None
	box = gtk.VBox(False, 0)

	url = 'http://moutons.ch/map2/?tr=&p='

	update_interval = 60 #in minute

	def __init__(self, **keyword_args):
		# init stuff
		screenlets.Screenlet.__init__(self, width=int(self.width*self.scale), height=int(self.height*self.scale),uses_theme=True, 
			is_widget=True, is_sticky=False, **keyword_args)
		
		self.add_option(IntOption('Earthquake', 'update_interval',
                                  self.update_interval, 'Interval 2 refresh in min.', 
                                  'The interval of time between two screenlet refresh in minute',  min=3, max=1440))
		
		#self.disable_option('scale')
		# create container for our moz-widget
		self.theme_name = "default"
		if self.box != None:
			
			self.box.set_border_width(int(15*self.scale))

			# create evntbox
		
			self.box.set_size_request(int((self.width-30)*self.scale),int((self.height-30)*self.scale))
			self.moz = webkit.WebView()
			self.moz.set_size_request(int((self.width-30)*self.scale),int((self.height-30)*self.scale))
			
			self.moz.open(str(self.url))
		
			# add/show all inputs
			self.box.pack_start(self.moz, False, False, 0)
			self.box.set_uposition(1,1)
			self.window.add(self.box)		
		
			self.window.show_all()
			
			
	def on_init(self):
		self.add_default_menuitems()

	def on_draw(self, ctx):
		ctx.scale(self.scale, self.scale)
		ctx.set_source_rgba(0, 0, 0, 0)
 		ctx.rectangle(0, 0, self.width*self.scale, self.height*self.scale)
		ctx.fill()
		
		
			#self.box = None
		if self.theme:
			self.theme['bg.svg'].render_cairo(ctx)
		
 	def on_mouse_down(self,event):
		x = event.x / self.scale
		y = event.y / self.scale

		
		if y >= 48 and y <= 60 and x >= 71 and x <= 247:
			self.moz.open(str(self.url))


		self.redraw_canvas()


	def on_scale(self):
		print 'scaling'

		if self.window:
			self.box.set_border_width(int(15*self.scale))
			self.box.set_uposition(1,1)
			self.moz.set_size_request(int((self.width-30)*self.scale),int((self.height-30)*self.scale))
		try:
			self.moz.open(str(self.url + self.update_interval))
		except:
			dialog = gtk.MessageDialog(buttons=gtk.BUTTONS_CLOSE)
			dialog.set_markup('unable to contact moutons.ch -> exit')
			dialog.run()
			dialog.destroy()
			print "unable to contact moutons.ch -> exit"
			sys.exit()
	def on_draw_shape(self, ctx):
		ctx.scale(self.scale, self.scale)
		ctx.set_source_rgba(0, 0, 0, 1)
 		ctx.rectangle(0, 0, self.width*self.scale, self.height*self.scale)
		ctx.fill()
		if self.theme:
			self.theme['bg.svg'].render_cairo(ctx)
			

if __name__ == "__main__":
	# create new session
	import screenlets.session
	screenlets.session.create_session(EarthquakeScreenlet)

